
#define EVERYTHING_PLUGIN_API	WINAPI

#define EVERYTHING_PLUGIN_LOCALIZATION_EVERYTHING								0
#define EVERYTHING_PLUGIN_LOCALIZATION_OK										4
#define EVERYTHING_PLUGIN_LOCALIZATION_SEARCH_EVERYTHING						97

#define EVERYTHING_PLUGIN_LOCALIZATION_NAME										101
#define EVERYTHING_PLUGIN_LOCALIZATION_PATH										102
#define EVERYTHING_PLUGIN_LOCALIZATION_SIZE										103
#define EVERYTHING_PLUGIN_LOCALIZATION_DATE_MODIFIED							104

#define EVERYTHING_PLUGIN_LOCALIZATION_TEXT_FILES								112
#define EVERYTHING_PLUGIN_LOCALIZATION_ALL_FILES								113
#define EVERYTHING_PLUGIN_LOCALIZATION_KB										114

#define EVERYTHING_PLUGIN_LOCALIZATION_CANCEL									172

#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER								177
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER								178

#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_PORT							260
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_PORT_HELP						261
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_PASSWORD						262
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_PASSWORD_HELP					263
#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_ETP_SERVER_LOGGING				268
#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_ETP_SERVER_LOGGING_HELP			269
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_LOG_FILE								270
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_LOG_FILE_HELP						271
#define EVERYTHING_PLUGIN_LOCALIZATION_START_ETP_SERVER_ON_STARTUP				272
#define EVERYTHING_PLUGIN_LOCALIZATION_START_ETP_SERVER_ON_STARTUP_HELP			273
#define EVERYTHING_PLUGIN_LOCALIZATION_BROWSE_FOR_THE_ETP_SERVER_LOG_FILE		274
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_LOG_MAX_SIZE_HELP				275
#define EVERYTHING_PLUGIN_LOCALIZATION_SAVE_ETP_SERVER_LOG_FILE					277

#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_PORT							278
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_PORT_HELP					279
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_USERNAME						280
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_USERNAME_HELP				281
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_PASSWORD						282
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_PASSWORD_HELP				283
#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_HTTP_SERVER_LOGGING				284
#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_HTTP_SERVER_LOGGING_HELP			285
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_LOG_FILE						286
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_LOG_FILE_HELP				287
#define EVERYTHING_PLUGIN_LOCALIZATION_BROWSE_FOR_THE_HTTP_SERVER_LOG_FILE		290
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_LOG_MAX_SIZE					291
#define EVERYTHING_PLUGIN_LOCALIZATION_SAVE_HTTP_SERVER_LOG_FILE				293

#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_ALLOW_FILE_DOWNLOAD			350
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_ALLOW_FILE_DOWNLOAD_HELP		351
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_ALLOW_FILE_DOWNLOAD			352
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_ALLOW_FILE_DOWNLOAD_HELP		353

#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_USERNAME						358
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_USERNAME_HELP					359

#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_INDEX_OF						1070
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_UP_ONE_DIRECTORY				1071
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_ONE_RESULT_FORMAT			1072
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_X_RESULTS_FORMAT				1073
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_X_TO_Y_OF_Z_RESULTS_FORMAT	1074
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_PREVIOUS						1075
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_NEXT							1076
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_BINDINGS						1077
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_BINDINGS_HELP				1078
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_TITLE_FORMAT					1079
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_LOG_FILE_BROWSE				1080
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_SERVE_PAGES_FROM				1081
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_SERVE_PAGES_FROM_HELP		1082
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_SERVE_PAGES_FROM_BROWSE		1083
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_SERVE_PAGES_FROM_BROWSE_HELP	1084
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_DEFAULT_PAGE					1085
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_DEFAULT_PAGE_HELP			1086
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_DEFAULT_PAGE_BROWSE			1087
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_DEFAULT_PAGE_BROWSE_HELP		1088
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_MAX_LOG_SIZE					1089
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_RESTORE_DEFAULTS				1090
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_RESTORE_DEFAULTS_HELP		1091
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_SELECT_HOME_CAPTION			1092
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_SELECT_DEFAULT_PAGE_CAPTION	1093

#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_BINDINGS						1094
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_BINDINGS_HELP					1095
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_MAX_LOG_SIZE					1096
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_LOG_FILE_BROWSE				1097
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_RESTORE_DEFAULTS				1098
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_RESTORE_DEFAULTS_HELP			1099
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_ERROR_FORMAT					1100
#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_ERROR_FORMAT					1101
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_CLIENT_ERROR_FORMAT					1102
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_CLIENT_DISCONNECTED_FORMAT			1103

#define EVERYTHING_PLUGIN_LOCALIZATION_LISTEN_FAILED_FORMAT						1114
#define EVERYTHING_PLUGIN_LOCALIZATION_BIND_FAILED_FORMAT						1115
#define EVERYTHING_PLUGIN_LOCALIZATION_CONNECT_FAILED_FORMAT					1116
#define EVERYTHING_PLUGIN_LOCALIZATION_GETADDRINFO_FAILED_FORMAT				1117
#define EVERYTHING_PLUGIN_LOCALIZATION_CONNECTION_CLOSED_BY_SERVER				1118
#define EVERYTHING_PLUGIN_LOCALIZATION_SOCKET_FAILED_FORMAT						1119
#define EVERYTHING_PLUGIN_LOCALIZATION_WSASTARTUP_FAILED_FORMAT					1120
#define EVERYTHING_PLUGIN_LOCALIZATION_UNSUPPORTED_WSADATA_FORMAT				1121
#define EVERYTHING_PLUGIN_LOCALIZATION_RECV_FAILED_FORMAT						1122
#define EVERYTHING_PLUGIN_LOCALIZATION_SEND_FAILED_FORMAT						1123
#define EVERYTHING_PLUGIN_LOCALIZATION_NO_MORE_ADDRINFO							1124
#define EVERYTHING_PLUGIN_LOCALIZATION_INVALID_USERNAME_OR_PASSWORD				1125

#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_ETP_SERVER						1156
#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_ETP_SERVER_HELP					1157
#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_HTTP_SERVER						1158
#define EVERYTHING_PLUGIN_LOCALIZATION_ENABLE_HTTP_SERVER_HELP					1159

#define EVERYTHING_PLUGIN_LOCALIZATION_HTTP_SERVER_DESCRIPTION					2398
#define EVERYTHING_PLUGIN_LOCALIZATION_ETP_SERVER_DESCRIPTION					2399
#define EVERYTHING_PLUGIN_LOCALIZATION_EVERYTHING_SERVER						2400
#define EVERYTHING_PLUGIN_LOCALIZATION_EVERYTHING_SERVER_DESCRIPTION			2401
#define EVERYTHING_PLUGIN_LOCALIZATION_PLUGIN_LINK								2402

#define EVERYTHING_PLUGIN_OS_WINSOCK_INADDR_ANY         			(unsigned long)0x00000000
#define EVERYTHING_PLUGIN_OS_WINSOCK_IPPROTO_TCP					6               /* tcp */
#define EVERYTHING_PLUGIN_OS_WINSOCK_SOCK_STREAM					1               /* stream socket */
#define EVERYTHING_PLUGIN_OS_WINSOCK_AI_PASSIVE						0x1  /* Socket address will be used in bind() call */
#define EVERYTHING_PLUGIN_OS_WINSOCK_AF_INET        				2               /* internetwork: UDP, TCP, etc. */
#define EVERYTHING_PLUGIN_OS_WINSOCK_AF_INET6       				23              /* Internetwork Version 6 */
#define EVERYTHING_PLUGIN_OS_WINSOCK_SOMAXCONN      				0x7fffffff
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_READ_BIT					0
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_READ          				(1 << EVERYTHING_PLUGIN_OS_WINSOCK_FD_READ_BIT)
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_WRITE_BIT     				1
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_WRITE         				(1 << EVERYTHING_PLUGIN_OS_WINSOCK_FD_WRITE_BIT)
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_ACCEPT_BIT    				3
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_ACCEPT        				(1 << EVERYTHING_PLUGIN_OS_WINSOCK_FD_ACCEPT_BIT)
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_CONNECT_BIT					4
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_CONNECT						(1 << EVERYTHING_PLUGIN_OS_WINSOCK_FD_CONNECT_BIT)
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_CLOSE_BIT     				5
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_CLOSE         				(1 << EVERYTHING_PLUGIN_OS_WINSOCK_FD_CLOSE_BIT)
#define EVERYTHING_PLUGIN_OS_WSADESCRIPTION_LEN      				256
#define EVERYTHING_PLUGIN_OS_WSASYS_STATUS_LEN       				128
#define EVERYTHING_PLUGIN_OS_WINSOCK_SD_SEND         				0x01
#define EVERYTHING_PLUGIN_OS_WINSOCK_SS_MAXSIZE						128                  // Maximum size.
#define EVERYTHING_PLUGIN_OS_WINSOCK_SS_ALIGNSIZE					(sizeof(__int64))  // Desired alignment.
#define EVERYTHING_PLUGIN_OS_WINSOCK_PF_INET						EVERYTHING_PLUGIN_OS_WINSOCK_AF_INET
#define EVERYTHING_PLUGIN_OS_WINSOCK_PF_INET6						EVERYTHING_PLUGIN_OS_WINSOCK_AF_INET6
#define EVERYTHING_PLUGIN_OS_WSAGETSELECTEVENT(lParam)				LOWORD(lParam)
#define EVERYTHING_PLUGIN_OS_WSAGETSELECTERROR(lParam)				HIWORD(lParam)
#define EVERYTHING_PLUGIN_OS_WINSOCK_AF_UNSPEC						0               /* unspecified */
#define EVERYTHING_PLUGIN_OS_WINSOCK_PF_UNSPEC						EVERYTHING_PLUGIN_OS_WINSOCK_AF_UNSPEC
#define EVERYTHING_PLUGIN_OS_WINSOCK_WSAOVERLAPPED      			OVERLAPPED
#define EVERYTHING_PLUGIN_OS_WINSOCK_WSAEVENT						HANDLE
#define EVERYTHING_PLUGIN_OS_WINSOCK_WSA_MAXIMUM_WAIT_EVENTS		(MAXIMUM_WAIT_OBJECTS)
#define EVERYTHING_PLUGIN_OS_WINSOCK_WSA_INVALID_EVENT				((EVERYTHING_PLUGIN_OS_WINSOCK_WSAEVENT)NULL)
#define EVERYTHING_PLUGIN_OS_WINSOCK_WSA_IO_PENDING					(ERROR_IO_PENDING)
#define EVERYTHING_PLUGIN_OS_WINSOCK_FD_MAX_EVENTS					10
#define EVERYTHING_PLUGIN_OS_WINSOCK_WSA_WAIT_TIMEOUT				(WAIT_TIMEOUT)
#define EVERYTHING_PLUGIN_OS_WINSOCK_INVALID_SOCKET					(EVERYTHING_PLUGIN_OS_WINSOCK_SOCKET)(~0)
#define EVERYTHING_PLUGIN_OS_WINSOCK_SOCKET_ERROR					(-1)

#define EVERYTHING_PLUGIN_UTF8_BASIC_STRING_TEXT(s)					((everything_plugin_utf8_t *)(((everything_plugin_utf8_basic_string_t *)(s)) + 1))

#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_RESULTS_CHANGED			0
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_STATUS_CHANGED				1
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_FILE_INFO_CHANGED			2
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_READY						3
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_ACCESS_DENIED				4
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_QUERY_COMPLETE				5
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_SORT_COMPLETE				6
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_QUERY_START				7
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_SORT_START					8
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_ON_LOADED					9
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_ON_INDEX_CANCELLED			10
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_TREEVIEW_CHANGED			11
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_TREEVIEW_PROPERTY_CHANGED	12
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_TREEVIEW_SELECTION_CHANGED	13
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_TREEVIEW_CLEARED			14
#define EVERYTHING_PLUGIN_DB_QUERY_EVENT_OFFLINE_CHANGED			15

#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_NONE						0
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_DUPLICATED_ONLY			1 // removes non duplicates.
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_DUPLICATED_ONLY_NOCASE	2		
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_UNIQUE					3 // removes duplicates
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_UNIQUE_NOCASE			4
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_DISTINCT					5 // removes secondary duplicates (keeps one duplicate).
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_DISTINCT_NOCASE			6
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_NOT_DISTINCT				7 // keeps only secondary duplicates.
#define EVERYTHING_PLUGIN_DB_QUERY_FIND_DUPLICATES_NOT_DISTINCT_NOCASE		8

#define EVERYTHING_PLUGIN_CONFIG_SIZE_STANDARD_JEDEC				0
#define EVERYTHING_PLUGIN_CONFIG_SIZE_STANDARD_IEC					1
#define EVERYTHING_PLUGIN_CONFIG_SIZE_STANDARD_METRIC				2

#define EVERYTHING_PLUGIN_PROPERTY_TYPE_NAME						0
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_PATH						1
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_SIZE						2
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_EXTENSION					3
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_TYPE						4
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_DATE_MODIFIED				5
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_DATE_CREATED				6
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_DATE_ACCESSED				7
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_ATTRIBUTES					8
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_DATE_RECENTLY_CHANGED		9
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_RUN_COUNT					10
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_DATE_RUN					11
#define EVERYTHING_PLUGIN_PROPERTY_TYPE_FILE_LIST_FILENAME			12

#define EVERYTHING_PLUGIN_PM_INIT						1 // system is initialized. This is always sent first, passes a everything_plugin_get_proc_address_t
#define EVERYTHING_PLUGIN_PM_GET_PLUGIN_VERSION			2 // return (void *)EVERYTHING_PLUGIN_VERSION
#define EVERYTHING_PLUGIN_PM_GET_NAME					3 // return name as NULL terminated const utf8_t *
#define EVERYTHING_PLUGIN_PM_GET_DESCRIPTION			4 // return description as NULL terminated const utf8_t *
#define EVERYTHING_PLUGIN_PM_GET_AUTHOR					5 // return author as NULL terminated const utf8_t *
#define EVERYTHING_PLUGIN_PM_GET_VERSION				6 // return version as NULL terminated const utf8_t *
#define EVERYTHING_PLUGIN_PM_GET_LINK					7 // return URL as NULL terminated const utf8_t *
#define EVERYTHING_PLUGIN_PM_START						8 // called to start plugin.
#define EVERYTHING_PLUGIN_PM_STOP						9 // windows are still open, everything is shutting down
#define EVERYTHING_PLUGIN_PM_KILL						10 // windows closed, this is the last message sent
#define EVERYTHING_PLUGIN_PM_UNINSTALL					11 // custom uninstall, called after STOP
#define EVERYTHING_PLUGIN_PM_ADD_OPTIONS_PAGES			12 // add custom pages now. _ui_options_add_custom_page_t
#define EVERYTHING_PLUGIN_PM_LOAD_OPTIONS_PAGE			13 // plugin_load_options_page_t
#define EVERYTHING_PLUGIN_PM_SAVE_OPTIONS_PAGE			14 // plugin_save_options_page_t
#define EVERYTHING_PLUGIN_PM_GET_OPTIONS_PAGE_MINMAX	15 // plugin_get_options_page_minmax_t
#define EVERYTHING_PLUGIN_PM_SIZE_OPTIONS_PAGE			16 // plugin_size_options_page_t
#define EVERYTHING_PLUGIN_PM_OPTIONS_PAGE_PROC			17 // plugin_options_page_proc_t
#define EVERYTHING_PLUGIN_PM_KILL_OPTIONS_PAGE			18 // user_data, called after page has been destroyed.
#define EVERYTHING_PLUGIN_PM_SAVE_SETTINGS				19 // output_stream_t

#define EVERYTHING_PLUGIN_VERSION						1

#define EVERYTHING_PLUGIN_OS_DLG_STATIC_SEPARATOR		3
#define EVERYTHING_PLUGIN_OS_DLG_SEPARATOR				6
#define EVERYTHING_PLUGIN_OS_DLG_STATIC_HIGH			15
#define EVERYTHING_PLUGIN_OS_DLG_BUTTON_HIGH			23
#define EVERYTHING_PLUGIN_OS_DLG_EDIT_HIGH				21
#define EVERYTHING_PLUGIN_OS_DLG_COMBOBOX_HIGH			21
#define EVERYTHING_PLUGIN_OS_DLG_DATETIME_HIGH			21
#define EVERYTHING_PLUGIN_OS_DLG_CHECKBOX_HIGH			15
#define EVERYTHING_PLUGIN_OS_DLG_3CONFIG_CHECKBOX_HIGH	15
#define EVERYTHING_PLUGIN_OS_DLG_RADIO_BUTTON_HIGH		15

#define EVERYTHING_PLUGIN_QWORD_MAX						0xffffffffffffffffui64
#define EVERYTHING_PLUGIN_DWORD_MAX						0xffffffff

#define EVERYTHING_PLUGIN_UTF8_BUF_STACK_SIZE			(MAX_PATH)

#define EVERYTHING_PLUGIN_ANSI_BUF_STACK_SIZE			(MAX_PATH)

#define EVERYTHING_PLUGIN_FILTER_FLAG_CASE						0x00000001
#define EVERYTHING_PLUGIN_FILTER_FLAG_WHOLEWORD					0x00000002
#define EVERYTHING_PLUGIN_FILTER_FLAG_PATH						0x00000004
#define EVERYTHING_PLUGIN_FILTER_FLAG_DIACRITICS				0x00000008
#define EVERYTHING_PLUGIN_FILTER_FLAG_REGEX						0x00000010
#define EVERYTHING_PLUGIN_FILTER_FLAG_PREFIX					0x00000020
#define EVERYTHING_PLUGIN_FILTER_FLAG_SUFFIX					0x00000040
#define EVERYTHING_PLUGIN_FILTER_FLAG_IGNORE_PUNCTUATION		0x00000080
#define EVERYTHING_PLUGIN_FILTER_FLAG_IGNORE_WHITESPACE			0x00000100
#define EVERYTHING_PLUGIN_FILTER_FLAG_SORT_DESCENDING			0x00000200

typedef unsigned __int64 EVERYTHING_PLUGIN_QWORD;
typedef uintptr_t EVERYTHING_PLUGIN_OS_WINSOCK_SOCKET;
typedef BYTE everything_plugin_utf8_t;
typedef void *everything_plugin_db_t;
typedef struct everything_plugin_db_query_s everything_plugin_db_query_t;
typedef void *everything_plugin_output_stream_t;
typedef struct everything_plugin_os_thread_s everything_plugin_os_thread_t;
typedef struct everything_plugin_db_find_s everything_plugin_db_find_t;
typedef struct everything_plugin_ini_s everything_plugin_ini_t;
typedef struct everything_plugin_property_s everything_plugin_property_t;
typedef struct everything_plugin_db_snapshot_s everything_plugin_db_snapshot_t;
typedef struct everything_plugin_timer_s everything_plugin_timer_t;
typedef struct everything_plugin_db_remap_array_s everything_plugin_db_remap_array_t;
typedef struct everything_plugin_db_snapshot_file_s everything_plugin_db_snapshot_file_t;
typedef struct everything_plugin_db_journal_file_s everything_plugin_db_journal_file_t;
typedef struct everything_plugin_db_journal_notification_s everything_plugin_db_journal_notification_t;
typedef void *(EVERYTHING_PLUGIN_API *everything_plugin_get_proc_address_t)(const everything_plugin_utf8_t *name);
typedef struct _OVERLAPPED *EVERYTHING_PLUGIN_OS_WINSOCK_LPWSAOVERLAPPED;
typedef void (CALLBACK * EVERYTHING_PLUGIN_OS_WINSOCK_LPWSAOVERLAPPED_COMPLETION_ROUTINE)(IN DWORD dwError,IN DWORD cbTransferred,IN EVERYTHING_PLUGIN_OS_WINSOCK_LPWSAOVERLAPPED lpOverlapped,IN DWORD dwFlags);
typedef struct everything_plugin_db_remap_list_s everything_plugin_db_remap_list_t;

typedef struct everything_plugin_utf8_buf_s
{
	// pointer to data.
	everything_plugin_utf8_t *buf; 
	
	// length in bytes of buf excluding null terminator.
	uintptr_t len;
	
	// the available size in buf.
	// if set to 0, then buf points to a external const buffer.
	uintptr_t size; 
	
	// a temp buffer
	everything_plugin_utf8_t stack[EVERYTHING_PLUGIN_UTF8_BUF_STACK_SIZE];
	
}everything_plugin_utf8_buf_t;

typedef struct everything_plugin_fileinfo_fd_s
{
	EVERYTHING_PLUGIN_QWORD size;
	EVERYTHING_PLUGIN_QWORD date_created;
	EVERYTHING_PLUGIN_QWORD date_modified;
	EVERYTHING_PLUGIN_QWORD date_accessed;
	DWORD attributes;
	
}everything_plugin_fileinfo_fd_t;

typedef struct everything_plugin_load_options_page_s
{
	// the userdata supplied in PLUGIN_EM_CREATE_OPTIONS_PAGE. 
	void *user_data; 
	
	// the page window handle.
	HWND page_hwnd;
	
	// the tooltip hwnd.
	HWND tooltip_hwnd;
	
}everything_plugin_load_options_page_t;

typedef struct everything_plugin_options_page_proc_s
{
	void *user_data;
	HWND options_hwnd;
	HWND page_hwnd;
	int msg;
	WPARAM wParam;
	LPARAM lParam;
	LRESULT result;
	int handled;
	
}everything_plugin_options_page_proc_t;

typedef struct http_server_everything_plugin_proc_s
{
	const everything_plugin_utf8_t *name;
	void **proc_address_ptr;
	
}http_server_everything_plugin_proc_t;

typedef struct everything_plugin_save_options_page_s
{
	// the userdata supplied in PLUGIN_EM_CREATE_OPTIONS_PAGE. 
	void *user_data; 

	HWND page_hwnd;
	
	// set to non-zero to keep apply enabled.
	int enable_apply;
	
}everything_plugin_save_options_page_t;

typedef struct everything_plugin_get_options_page_minmax_s
{
	// the userdata supplied in PLUGIN_EM_CREATE_OPTIONS_PAGE. 
	void *user_data; 
	
	// opaque handle to the options window.
	HWND page_hwnd;
	
	// minimum width and minimum height in logical pixels.
	int wide;
	int high;
	
}everything_plugin_get_options_page_minmax_t;

typedef struct everything_plugin_size_options_page_s
{
	// the userdata supplied in PLUGIN_EM_CREATE_OPTIONS_PAGE. 
	void *user_data; 
	
	// opaque handle to the options window.
	HWND page_hwnd;

}everything_plugin_size_options_page_t;

struct everything_plugin_os_winsock_addrinfo
{
    int                 ai_flags;       // EVERYTHING_PLUGIN_OS_WINSOCK_AI_PASSIVE, AI_CANONNAME, OS_WINSOCK_AI_NUMERICHOST
    int                 ai_family;      // PF_xxx
    int                 ai_socktype;    // SOCK_xxx
    int                 ai_protocol;    // 0 or IPPROTO_xxx for IPv4 and IPv6
    size_t              ai_addrlen;     // Length of ai_addr
    char *              ai_canonname;   // Canonical name for nodename
    struct everything_plugin_os_winsock_sockaddr *   ai_addr;        // Binary address
    struct everything_plugin_os_winsock_addrinfo *   ai_next;        // Next structure in linked list
};


/*
 * Definitions used for os_winsock_sockaddr_storage structure paddings design.
 */
#define EVERYTHING_PLUGIN_OS_WINSOCK_SS_PAD1SIZE (EVERYTHING_PLUGIN_OS_WINSOCK_SS_ALIGNSIZE - sizeof (short))
#define EVERYTHING_PLUGIN_OS_WINSOCK_SS_PAD2SIZE (EVERYTHING_PLUGIN_OS_WINSOCK_SS_MAXSIZE - (sizeof (short) + EVERYTHING_PLUGIN_OS_WINSOCK_SS_PAD1SIZE \
                                                    + EVERYTHING_PLUGIN_OS_WINSOCK_SS_ALIGNSIZE))

struct everything_plugin_os_winsock_sockaddr_storage {
    short ss_family;               // Address family.
    char __ss_pad1[EVERYTHING_PLUGIN_OS_WINSOCK_SS_PAD1SIZE];  // 6 byte pad, this is to make
                                   // implementation specific pad up to
                                   // alignment field that follows explicit
                                   // in the data structure.
    __int64 __ss_align;            // Field to force desired structure.
    char __ss_pad2[EVERYTHING_PLUGIN_OS_WINSOCK_SS_PAD2SIZE];  // 112 byte pad to achieve desired size;
                                   // _OS_WINSOCK_SS_MAXSIZE value minus size of
                                   // ss_family, __ss_pad1, and
                                   // __ss_align fields is 112.
};

typedef struct EVERYTHING_PLUGIN_OS_WINSOCK_WSADATA 
{
        WORD                    wVersion;
        WORD                    wHighVersion;
#ifdef _WIN64
        unsigned short          iMaxSockets;
        unsigned short          iMaxUdpDg;
        char FAR *              lpVendorInfo;
        char                    szDescription[EVERYTHING_PLUGIN_OS_WSADESCRIPTION_LEN+1];
        char                    szSystemStatus[EVERYTHING_PLUGIN_OS_WSASYS_STATUS_LEN+1];
#else
        char                    szDescription[EVERYTHING_PLUGIN_OS_WSADESCRIPTION_LEN+1];
        char                    szSystemStatus[EVERYTHING_PLUGIN_OS_WSASYS_STATUS_LEN+1];
        unsigned short          iMaxSockets;
        unsigned short          iMaxUdpDg;
        char FAR *              lpVendorInfo;
#endif

}EVERYTHING_PLUGIN_OS_WINSOCK_WSADATA;

typedef struct everything_plugin_utf8_string_s
{
	// NULL terminated
	everything_plugin_utf8_t *text;
	
	// length of string in bytes.
	uintptr_t len;
	
}everything_plugin_utf8_string_t;

typedef struct everything_plugin_utf8_const_string_s
{
	// NULL terminated
	const everything_plugin_utf8_t *text;
	
	// length of string in bytes.
	uintptr_t len;
	
}everything_plugin_utf8_const_string_t;

typedef struct everything_plugin_utf8_basic_string_s
{
	// length of string in bytes.
	uintptr_t len;

	// NULL terminated text follows.
	// utf8_t text[len+1];
	
}everything_plugin_utf8_basic_string_t;

struct everything_plugin_os_winsock_sockaddr 
{
	unsigned short sa_family;              /* address family */
	char    sa_data[14];            /* up to 14 bytes of direct address */
};

struct everything_plugin_os_winsock_in6_addr 
{
    union {
        unsigned char Byte[16];
        unsigned short Word[8];
    } u;
};

struct everything_plugin_os_winsock_sockaddr_in6 
{
    short   sin6_family;        /* AF_INET6 */
    unsigned short sin6_port;          /* Transport level port number */
    unsigned long  sin6_flowinfo;      /* IPv6 flow information */
    struct everything_plugin_os_winsock_in6_addr sin6_addr;  /* IPv6 address */
    unsigned long sin6_scope_id;       /* set of interfaces for a scope */
};

struct everything_plugin_os_in_addr 
{
	union 
	{
		struct { unsigned char s_b1,s_b2,s_b3,s_b4; } S_un_b;
		struct { unsigned short s_w1,s_w2; } S_un_w;
		unsigned long S_addr;
	} S_un;
};

struct everything_plugin_os_sockaddr_in 
{
        short   sin_family;
        unsigned short sin_port;
        struct  everything_plugin_os_in_addr sin_addr;
        char    sin_zero[8];
};

typedef struct everything_plugin_ansi_buf_s
{
	char *buf;
	uintptr_t len;
	uintptr_t size;
	char stack[EVERYTHING_PLUGIN_ANSI_BUF_STACK_SIZE];
	
}everything_plugin_ansi_buf_t;

typedef struct everything_plugin_interlocked_s
{
	uintptr_t unaligned_a;
	uintptr_t unaligned_b;	
	
}everything_plugin_interlocked_t;

typedef struct EVERYTHING_PLUGIN_OS_WINSOCK_WSABUF {
    unsigned long      len;     /* the length of the buffer */
    char FAR *  buf;     /* the pointer to the buffer */

}EVERYTHING_PLUGIN_OS_WINSOCK_WSABUF;

typedef struct EVERYTHING_PLUGIN_OS_WINSOCK_WSANETWORKEVENTS 
{
	long lNetworkEvents;
	int iErrorCode[EVERYTHING_PLUGIN_OS_WINSOCK_FD_MAX_EVENTS];
	
} EVERYTHING_PLUGIN_OS_WINSOCK_WSANETWORKEVENTS;
